<html>
<!-- /usr/share/lightdm-webkit/themes/CouchNet/index.html
    Based on ../webkit/index.html (provided with the lightdm-webkit-greeter
    package, author unknown, no copyright notice.)  
    Hacks copyright (c) 2013 by Jim Carter <jimc@jfcarter.net> (2013-01-05) 
    Permission to use is granted without limitation.  No warranty for anything.
    -->
<head>
<meta http-equiv="Content-Script-Type" content="text/javascript">
<style type="text/css">

.ui {
    font: x-large serif;
    color: white;
    vertical-align: baseline;
}

.utxt {
    font: x-large serif;
    color: black;
    width: 95%;
}

/* There's a bug which causes black borders 16px wide around INPUT and SELECT
elements, only when served by Xvnc.  Seen in SuSE 11.4, gone in 12.3. */
.umgn {
    margin: 16px 0 16px 0;
}

.ubdr {
    margin: 0;
}

</style>

<!-- The binary code for lightdm-webkit-greeter may call these functions in
    the page, which therefore must be defined and working:
    * show_prompt(text)		Make $text the label of the password box and
				make it ready to accept a PW from the user.
    * show_message(text)	Show an info message in the message box.
    * authentication_complete()	Either show "auth failed" or log him in.
    * timed_login(user)		Log this user in after a delay.  Parameters:
				autologin-user		User passed to this fcn
				autologin-user-timeout	Wait this long to login
				SuSE's webkit greeter doesn't seem to call this
				function.  Have to do it ourself. 
    -->
<script type="text/javascript">

	// Screen dimensions (see http://responsejs.com/labs/dimensions/ )
	// Oh, blecch, each time webkit redraws the screen it enlarges it!
	// This has got to be abuse by the greeter code, but I'm not going to
	// debug it.  Instead I use my stupid cookie to hold the initial 
	// dimension.  See state[] below.
var scrwid = window.screen.width;
var scrhgt = window.screen.height;
        // For reference these are the window dimensions.  For the greeter they
	// are the same as the screen size.  Inner means inside borders and
	// browser toolbar; outer is outside those.
var winwid = window.innerWidth;
var winhgt = window.innerHeight;

	// You're supposed to be able to set in lightdm.conf, autologin-user
	// and autologin-timeout.  SuSE has hacked lightdm so 
	// /etc/sysconfig/displaymanager DISPLAYMANAGER_AUTOLOGIN overrides
	// this parameter, and the timeout is always 0.  Hiss, boo.
var preset_user = '%u';		// '' for no preset.  
var preset_timeout = %t;	// Auto login after %t secs, 0 = don't.
var preset_session = '%S';	// Only used for auto login
	 // Every time you sneeze the server reloads the page, so these items
	 // have to be saved in a cookie -- which fortunately works in webkit.
var state = new Object();
state['user'] = preset_user;	// The user who is logging on
state['session'] = '';		// Session type (KDE, Gnome, XFCE, etc.)
	 // Values for state['s']:
	 // 0	Nothing sent to server
	 // 1	LoginID sent in
	 // 2	Server has called show_prompt (wants password)
	 // 3	Password has been sent in, awaiting authentication_complete()
state['s'] = 0;
state['wid'] = scrwid;		// Original screen dimensions
state['hgt'] = scrhgt;
var debug_on = 0;		// 0 = no debug, 1 = show msg, 2 = alert boxes

// Resets the state variable to initial values.  Does *not* mess with cookies.
// Does not "reset" the screen size.  
function reset() {
    state['user'] = preset_user;
    state['session'] = '';
    state['s'] = 0;
}

// Copies the current state variables into the form's widgets.  
function show_state() {
    var ent, val, opt, i;
		// Make the body fill the original screen size.
    ent = document.getElementById('body');
    ent.style.width  = state['wid'];
    ent.style.height = state['hgt'];
		// Name of user
    ent = document.getElementById('i_user');
    ent.value = state['user'];
		// Session type: turn off all options except the stated one.
    val = state['session'];
    ent = document.getElementById('i_session');
    var len = ent.options.length;
    var isel = -1;
    for (i = 0; i < len ; ++i) {
	opt = ent.options[i];
	if (opt.value == val) isel = i;
	opt.selected = false;
    }
    if (isel >= 0) ent.options[isel].selected = true;
}

// For debugging, show the current state.
function debug_state(fcn) {
    if (debug_on > 0) {
	var ent = document.getElementById('p_state');
	ent.innerHTML = fcn + ' s=' + state['s'] + 
	    ' user=' + state['user'] + ' session=' + state['session'];
    }
}

// Retrieves the cookie and loads the respective state variables.  The cookie
// comes back in the form key1=val1; key2=val2; ...
function get_cookie() {
    var acookies = document.cookie.split(/; */);
    var i, j, c, ent, key, val, opt;
    for (i = 0; i < acookies.length; ++i) {
	c = acookies[i];
	j = c.indexOf("=");
	key = c.substr(0, j);
	val = c.substr(j+1);
	if (val == '') continue;
	switch (key) {
	    case 'user':
	    case 'session':
	    case 's':
		state[key] = val;
	}
    }
    debug_state('get');
}

// Stores the state variables in cookies of the form name=value.  The value 
// could be '' (which should erase the cookie, but OK if it doesn't).  
function set_cookie() {
    var key;
    for (key in state) {
	document.cookie = key + '=' + state[key];
    }
    debug_state('set');
}

// Sets up dynamic content that only has to be done once.  But suppose someone
// installs/removes a session type in /usr/share/xsessions, the greeter 
// won't notice until lightdm is restarted.  Not a big deal, I think. 
// Wacko: the page is reloaded at least when show_prompt is called, maybe on
// other calls, triggering a call to setup().  Variables do not persist.
function setup() {
		// Stuff session rows into the session listbox.
    show_debug('setup starting');
    var stuff='';
    for (i in lightdm.sessions) {
	s = lightdm.sessions[i];
	stuff += '<option value="' + s.key + '">' + 
	    s.name + '</option>';
    }
    elt = document.getElementById('i_session');
    elt.innerHTML = stuff;
		// Dynamically create the power management menu. 
    stuff = '<option value=none> Power Mgt </option>';
    if (lightdm.can_suspend)
	stuff += '<option value=suspend> Suspend </option>';
    if (lightdm.can_hibernate)
	stuff += '<option value=hibernate> Hibernate </option>';
    if (lightdm.can_restart)
	stuff += '<option value=restart> Restart </option>';
    if (lightdm.can_shutdown)
	stuff += '<option value=shutdown> Shutdown </option>';
    elt = document.getElementById('i_power');
    elt.innerHTML = stuff;
		// Reload the state variables from the cookie.
    get_cookie();
    show_state();
    debug_state('sup');
    if (state['s'] == 0)
	timed_login(preset_user);
    switch2();
}

// One table row (from r_user, r_passwd, r_confirm) is made visible and the
// others are hidden.  The visible row corresponds to the program's state.
// 0 -> r_user, 1 -> r_passwd, 2 or 3 -> r_confirm.  
function switch2() {
    var s = state['s'];
    var row, inp, i;
    var rows = ['r_user', 'r_passwd', 'r_confirm'];
    var inps = ['i_user', 'i_passwd', 'i_confirm'];
    var vizxl = [ 0, 1, 1, 2];
    var viz = vizxl[s];
    for (i = 0 ; i < 3 ; ++i) {
	row = document.getElementById(rows[i]);
	if (i == viz) {
	    row.style.display = 'table-row'; 
	    inp = document.getElementById(inps[i]);
	    inp.focus();
	} else {
	    row.style.display = 'none';
	}
    }
}

// Stuffs the message area with given text; give "" to clear it. 
function show_message(text)
{
    var label = document.getElementById('p_message');
    label.innerHTML = text;
}

// Like show_message but uses the debug row.
function show_debug(text)
{
    if (debug_on >= 1) {
	var text = state['s'] + ' ' + text;
	var label = document.getElementById('p_debug');
	label.innerHTML = text;
	if (debug_on >= 2)
	    alert(text);
    }
}

// Tries to log in the user.  Aborts if the userID has been altered.
function timed_login_try() {
    var entry = document.getElementById('i_user');
    var luser = entry.value;
    if (preset_user != "" && luser == preset_user) {
	show_debug('timed_login_try auths '+preset_user);
	state['session'] = preset_session;
	lightdm.start_authentication(preset_user);
    } else {
	show_debug('timed_login_try ignores '+luser);
    }
}

// Presets the user.  After $preset_timeout, it tries to log in the user.
function timed_login(user) {
    state['user'] = user;
    set_cookie();
    var entry = document.getElementById('i_user');
    entry.value = user;
    entry.focus();
    show_debug('timed_login('+user+') called.');
    if (preset_timeout > 0)
	setTimeout("timed_login_try()", 1000*preset_timeout);
}

// Server is ready for the password, and gives you the prompt string.
function show_prompt(text)
{
    state['s'] = 2;
    set_cookie();
    var label = document.getElementById('p_passwd');
    label.innerHTML = text;
    switch2();
    show_debug('show_prompt(' + text + ')');
}

// Main program logic: see if we're ready to authenticate, do it if so.
function try_auth() {
    var s = state['s'];
    show_message("");
    var viz = (s == 0) ? 'i_user' : 'i_passwd';
    var eviz = document.getElementById(viz);
    var val = eviz.value;
    show_debug('try_auth s=' + s + ' val=' + val)
    if (val == "") {
	var type = (s == 0) ? 'User' : 'Password';
	show_message(type + ' required');
    } else {
	if (s == 0) {
	    state['user'] = val;
	    show_debug("start_auth " + val);
	    state['s'] = 1;	//Don't call switch2(), still wants r_user
	    set_cookie();
	    lightdm.start_authentication(val);
	} else {
		// Sends in the password and awaits authentication_complete()
	    lightdm.provide_secret(val);
	    state['s'] = 3;
	    set_cookie();
	    switch2();
	    show_debug('provide_secret');
	}
    }
    eviz.focus();
}

// The binary code calls this when auth fails or succeeds. 
function authentication_complete()
{
   if (lightdm.is_authenticated) {
	var user = lightdm.authentication_user;
	var session = state['session'];
	show_message("Logging in " + user);
	if (session == 'default' || session == '') {
	     show_debug('login ' + user + '[, ' + session + '] (dflt)');
	     lightdm.login (user);
	} else {
	     show_debug('login ' + user + ', ' + session);
	     lightdm.login (user, session);
	}
	reset();
	set_cookie();
	show_state();
	switch2();
   } else {
	cancel_auth ("Authentication Failed");
   }
}

// Do a power management action
function power_mgt() {
    var entry = document.getElementById('i_power');
    var action = entry.value;
    if (action == "suspend") {
	show_debug('power_mgt(' + action + ')');
	lightdm.suspend();
    } else if (action == "hibernate") {
	show_debug('power_mgt(' + action + ')');
	lightdm.hibernate();
    } else if (action == "restart") {
	show_debug('power_mgt(' + action + ')');
	lightdm.restart();
    } else if (action == "shutdown") {
	show_debug('power_mgt(' + action + ')');
	lightdm.shutdown();
    } else {
	show_debug('power_mgt(' + action + ') (no action)');
    }
}

// Stores the user's selected session in a cookie "session=VALUE".  
function pick_session() {
    var entry = document.getElementById('i_session');
    state['session'] = entry.value;
    set_cookie();
    show_debug('Cookie session=' + entry.value);
}

// Resets everything to try authentication again.  
function cancel_auth(text) {
    show_debug("cancel_auth starting ");
    show_message(text);
    reset();
    set_cookie();
    show_state();
    debug_state('can');
    lightdm.cancel_authentication();
    switch2();
}

</script>
</head>

<!-- Webkit in this context does not honor a font style on the body. -->
<!-- "background:cover url()" declaration requires CSS-3 which greeter lacks -->
<body id=body onload="setup()" style="background: black">

<form onsubmit="try_auth()">

<img id=bkgd src="file:///m1/custom/background.jpeg" style="width:100%; margin-right:-32%; vertical-align:top">

<!-- For Mathnet we use background:#d9b78a, color of one brick in Royce Hall -->
<table style="width: 30%; vertical-align:top; display:inline; background:black; border: 0.2em white outset">
<!-- <col width="33%"><col width="67%"> -->

<tr id="r_title"> <td class=ui colspan=2 style="text-align:center"> %H on %D

<tr id="r_user"> <td class=ui> <div id=p_user class=umgn> User: </div>
<!-- If lightdm.conf sets autologin-user, setup() presets its value here. -->
<input class=utxt class=umgn id=i_user type=text>

<tr id="r_passwd"> <td class=ui> <div id=p_passwd class=umgn> Password: </div>
<input class=utxt class=umgn id=i_passwd type=password>

<tr id="r_confirm"> <td class=ui id=i_confirm colspan=2> Authenticating&hellip;

<tr id=r_submit>
<td class=ui style="text-align:center">
<button id=i_submit class=umgn type=submit name="login" 
	style="margin-right: 1em">Log In</button>
<button class=ymgn type=button name="cancel" 
	style="margin-left: 1em" onclick="cancel_auth('Cancelled')">
	Cancel</button>

<tr id=r_message>
<td class=ui id=p_message class=umgn> &nbsp; <!-- Javascript fills in the message here -->

<tr id=r_session>
<td class=ui style="text-align:center">
    <select id=i_session class=umgn name=session size=1
			 style="margin-right:1em" onchange="pick_session()">
    <!-- Options are filled in by setup() -->
    <!-- (option value=default selected) Default Session (/option) -->
    </select>

    <select id=i_power class=umgn name=power size=1 
			 style="margin-left:1em" onchange="power_mgt()">
    </select>

<tr id=r_debug>
<td class=ui id=p_debug> <!-- Javascript fills in the message here -->

<tr id=r_state>
<td class=ui id=p_state> <!-- Javascript fills in the message here -->

</table>

</form>

</body>

</html>
